<?php

namespace App\Enum;

enum ListingStatus: int
{
    case PENDING = 0;
    case ACTIVE = 1;
    case INACTIVE = 2;
    case APPROVED = 3;
    case REJECTED = 4; // Changed to a unique value
    case SUSPENDED = 5;

    public function label(): string
    {
        return match($this) {
            self::PENDING  => 'Pending',
            self::ACTIVE   => 'Active',
            self::INACTIVE => 'Inactive',
            self::APPROVED => 'Approved',
            self::REJECTED => 'Rejected',
            self::SUSPENDED => 'Suspended',
        };
    }

    // Get a badge HTML
    public function badge(): string
    {
        return match($this) {
            self::PENDING  => '<span class="badge bg-info">Pending</span>',
            self::ACTIVE   => '<span class="badge bg-success">Active</span>',
            self::INACTIVE => '<span class="badge bg-dark">Inactive</span>',
            self::APPROVED => '<span class="badge bg-primary">Approved</span>',
            self::REJECTED => '<span class="badge bg-danger">Rejected</span>',
            self::SUSPENDED => '<span class="badge bg-danger">Suspended</span>'
        };
    }
}
