<?php

namespace App\Enum;

enum Status: int
{
    case PENDING = 0;
    case ACTIVE = 1;
    case VERIFIED = 2;
    case INVITED = 3;
    case INACTIVE = 4;
    case SUSPENDED = 5;

    public function label(): string
    {
        return match($this) {
            self::PENDING => 'Pending',
            self::ACTIVE => 'Active',
            self::VERIFIED => 'Verified',
            self::INVITED => 'Invited',
            self::INACTIVE => 'Inactive',
            self::SUSPENDED => 'Suspended',
        };
    }

    // Get a badge HTML
    public function badge(): string
    {
        return match($this) {
            self::PENDING   => '<span class="badge bg-warning">Pending</span>',
            self::ACTIVE    => '<span class="badge bg-success">Active</span>',
            self::VERIFIED  => '<span class="badge bg-secondary">Verified</span>',
            self::INVITED   => '<span class="badge bg-info">Invited</span>',
            self::INACTIVE  => '<span class="badge bg-dark">Inactive</span>',
            self::SUSPENDED => '<span class="badge bg-danger">Suspended</span>',
        };
    }

}
