<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\LoginRequest;
use App\Models\Role;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use App\Models\Term;

class AuthenticatedSessionController extends Controller
{
    public function create()
    {
        $term = Term::wherePosition('login_page')->first();
        return view('auth.login', compact('term'));
    }

    public function store(LoginRequest $request): RedirectResponse
    {
        $request->authenticate();

        // Enforce admin-only login on admin routes
        if (! auth()->user()?->hasAnyRole([Role::ADMIN, Role::SUPER_ADMIN])) {
            Auth::guard('web')->logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();
            return redirect()->route('admin.login')->withErrors(['email' => trans('auth.failed')]);
        }

        $request->session()->regenerate();

        return redirect()->intended(route('dashboard', absolute: false));
    }
}
