<?php

namespace App\Http\Controllers\Auth;

use App\Enum\Status;
use App\Models\User;
use App\Http\Controllers\Controller;
use Illuminate\Auth\Events\Verified;
use Illuminate\Http\RedirectResponse;
use App\Services\ActivityLogs\AuthLogService;
use Illuminate\Foundation\Auth\EmailVerificationRequest;

class VerifyEmailController extends Controller
{
    /**
     * Mark the authenticated user's email address as verified.
     */
    public function __invoke(EmailVerificationRequest $request): RedirectResponse
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->intended(route('dashboard', absolute: false) . '?verified=1');
        }

        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));
        }

        auth()->user()->update(['status' => Status::VERIFIED]);

        (new AuthLogService())->emailVerified();

        return redirect()->intended(route('dashboard', absolute: false) . '?verified=1');
    }
}
