<?php

namespace App\Http\Controllers\Buyer;

use App\Models\Listing;
use Illuminate\View\View;
use App\Http\Controllers\Controller;

class ShopController extends Controller
{
    public function index(): View
    {
        $cars = Listing::with(['specification', 'owner'])
            ->latest()
            ->get()
            ->map(function ($item) {
                return (object)[
                    'name'  => $item->title ?? 'No Title',
                    'type'  => $item->specification?->body_type ?? 'Sedan',
                    'year'  => $item->specification?->year ?? '----',
                    'price' => $item->price ?? 0,
                    'image_url' => $item->image_url && is_array($item->image_url) && count($item->image_url) > 0
                        ? $item->image_url[0]
                        : asset('assets/buyer/home/no-image.png'),
                    'city'  => $item->location ?? 'Unknown',
                    'agent' => $item->owner?->name ?? 'Dealer',
                    'added_at' => $item->created_at,
                    'specs' => [
                        [
                            'icon' => asset('assets/buyer/home/speedmeter.png'),
                            'value' => $item->specification?->mileage
                                ? $item->specification->mileage . ' Miles'
                                : 'Mileage'
                        ],
                        [
                            'icon' => asset('assets/buyer/home/twinscroll.png'),
                            'value' => $item->specification?->engine_capacity ?? 'Engine'
                        ],
                        [
                            'icon' => asset('assets/buyer/home/gasonline.png'),
                            'value' => $item->specification?->fuel_type ?? 'Fuel'
                        ],
                        [
                            'icon' => asset('assets/buyer/home/automatic.png'),
                            'value' => $item->specification?->transmission ?? 'Auto'
                        ],
                    ],
                ];
            });

        return view('buyer.shop', compact('cars'));
    }
}
