<?php

namespace App\Http\Controllers\Dealer;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class SettingsController extends Controller
{
    private $allowedKeys = [
        'is_compact_sidebar',
        'is_dark_mode',
    ];

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
        try {
            DB::beginTransaction();

            foreach ($this->allowedKeys as $key) {
                if (!$request->has($key)) continue;

                auth()->user()->settings()->updateOrCreate([
                    'key' => $key,
                ], [
                    'value' => $request->input($key) ?? false
                ]);
            }

            DB::commit();

            return $this->jsonResponse(trans('global.toast.success.saved'), JsonResponse::HTTP_OK);
        } catch (\Exception $e) {
            DB::rollBack();
            return $this->jsonResponse($e->getMessage(), $e->getCode());
        }
    }
}

