<?php

namespace App\Http\Controllers\Profile;

use Illuminate\View\View;
use App\Traits\FileUploader;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class AvatarController extends Controller
{
    use FileUploader;

    public function edit(): View
    {
        return view('profile.modals.avatar');
    }

    public function update(Request $request): JsonResponse
    {
        try {
            $validator = Validator::make($request->all(), [
            'avatar' => 'required|file|mimes:jpg,png,gif|max:1024', // 1 MB
            ], [
                'avatar.max' => 'Avatar must be less than 1 MB.'
            ]);

            if ($validator->fails()) {
                throw new \Exception($validator->errors()->first(), JsonResponse::HTTP_UNPROCESSABLE_ENTITY);
            }

            $path = $this->uploadPublicImage(
                $request->file('avatar'),
                'avatars',
                auth()->user()->avatar
            );

            auth()->user()->update([
                'avatar' => $path,
            ]);

            return $this->jsonResponse([
                'message' => 'Avatar updated successfully.',
                'params' => [
                    'url' => Storage::url($path)
                ]
            ]);
        } catch (\Exception $e) {
            $code = $e->getCode() ?: JsonResponse::HTTP_UNPROCESSABLE_ENTITY;
            return $this->jsonResponse($e->getMessage(), $e->getCode());
        }
    }
}
