<?php

namespace App\Http\Controllers\Settings;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Routing\Controllers\Middleware;
use Illuminate\Routing\Controllers\HasMiddleware;

class SettingController extends Controller implements HasMiddleware
{
    private $allowedKeys = [
        'is_compact_sidebar',
        'is_dark_mode',
    ];

    public static function middleware(): array
    {
        return [
            new Middleware('permission:setting.view', only: ['index']),
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('settings.index');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request): JsonResponse
    {
        try {
            DB::beginTransaction();

            foreach ($this->allowedKeys as $key) {
                if (!$request->has($key)) continue;

                auth()->user()->settings()->updateOrCreate([
                    'key' => $key,
                ], [
                    'value' => $request->input($key) ?? false
                ]);
            }

            DB::commit();

            return $this->jsonResponse('Settings saved successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
            return $this->jsonResponse($e->getMessage(), $e->getCode());
        }
    }
}
