<?php

namespace App\Http\Middleware;

use App\Enum\Status;
use App\Models\User;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ActiveUser
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->user()->status == Status::VERIFIED) {
            return $request->expectsJson()
                ? throw new \Exception('Unauthenticated')
                : redirect()->route('profile.index');
        }

        return $next($request);
    }
}
