<?php

namespace App\Http\Middleware;

use App\Enum\Status;
use Closure;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class BlockIfSuspended
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ((auth()->user()->isUser() || auth()->user()->isUser()) && auth()->user()->status == Status::SUSPENDED) {
            Auth::guard('web')->logout();

            $request->session()->invalidate();

            $request->session()->regenerateToken();

            return redirect()->route('login')->with([
                'status' => 'Your account has been suspended for an indefinite period.'
            ]);
        }

        return $next($request);
    }
}
