<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Symfony\Component\HttpFoundation\Response;

class SwaggerAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $accessKey = config('api.swagger_access_key');
        
        // Check if access key is configured
        if (empty($accessKey) || $accessKey === 'swagger-docs-key-12345') {
            abort(403, 'Swagger documentation access is not configured.');
        }

        // Check if key is provided in query string or session
        $providedKey = $request->query('key') ?? $request->session()->get('swagger_access_key');
        
        // If no key provided, show login form
        if (empty($providedKey)) {
            return response()->view('swagger.auth', [], 401);
        }

        // Validate the key
        if ($providedKey !== $accessKey) {
            return response()->view('swagger.auth', [
                'error' => 'Invalid access key. Please try again.'
            ], 401);
        }
    

        return $next($request);
    }
}

