<?php

namespace App\Http\Middleware;

use App\Enum\Status;
use App\Models\Dealers\Dealer;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class VerifiedDealer
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (!auth()->check()) {
            return redirect()->route('dealers.login');
        }

        // Check if user has dealer role
        if (!auth()->user()->hasRole(\App\Models\Role::DEALER)) {
            abort(403, trans('auth.dealer_not_authorized'));
        }

        // Check if dealer is verified/approved
        $dealer = Dealer::whereHas('user', function ($q) {
            $q->where('id', auth()->id());
        })->with('user')->first();

        if (!$dealer || !$dealer->user) {
            auth()->logout();
            return redirect()->route('dealers.login')
                ->withErrors(['email' => trans('auth.dealer_profile_not_found')]);
        }

        // Check if dealer user is active
        if ($dealer->user->status !== Status::ACTIVE) {
            auth()->logout();
            return redirect()->route('dealers.login')
                ->withErrors(['email' => trans('auth.dealer_pending_approval')]);
        }

        return $next($request);
    }
}

