<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

class VerifyOtp
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && empty(auth()->user()->email_verified_at)) {
            return response()->json([
                'success' => false,
                'message' => 'Please verify your email.',
                'data' => [
                    'user' => [
                        'is_email_verified' => 0,
                    ]
                ]
            ], JsonResponse::HTTP_FORBIDDEN);
            throw new \Exception('Please verify your email.', JsonResponse::HTTP_FORBIDDEN);
        }

        return $next($request);
    }
}
