<?php

namespace App\Http\Requests\Dealer;

use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // Company
            'company_name'            => 'required|string|max:255',
            'registration_number'     => 'required|string|max:255|unique:dealers,registration_number',
            'tax_id'                   => 'required|string|max:255|unique:dealers,tax_identification_number',

            // Contact
            'company_email'            => 'required|email|max:255|unique:users,email',
            'company_phone'            => 'required|string|max:30',

            // Representative
            'rep_name'                 => 'required|string|max:255',
            'rep_cnic'                 => 'required|string|regex:/^\d{5}-\d{7}-\d{1}$/',
            'rep_position'              => 'required|string|max:255',
            'rep_contact'               => 'required|string|max:30',

            // Financial
            'bank_name'                 => 'required|string|max:255',
            'account_holder'            => 'required|string|max:255',
            'account_number'             => 'required|string|max:255',

            // Address
            'country'                    => 'required|string|max:100',
            'state'                      => 'required|string|max:100',
            'city'                       => 'required|string|max:100',
            'street'                     => 'required|string|max:255',
            'postal_code'                 => 'required|string|max:20',

            // Terms
            'terms'                       => 'accepted',

            // Password
            'password'                    => 'required|string|min:8|confirmed',
        ];
    }
}
