<?php

namespace App\Http\Requests\Profile;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\Rule|array|string>
     */
    public function rules(): array
    {
        return [
            'first_name' => 'required|max:50',
            'last_name' => 'required|max:50',
            'gender' => 'nullable|string|in:' . implode(',', [User::GENDER_MALE, User::GENDER_FEMALE]),
            'dob' => 'nullable|date_format:Y-m-d|before_or_equal:' . now()->subYear()->format('Y-m-d'),
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'dob.date_format' => 'The dob field must match the format yyyy-mm-dd. E.g. 1990-01-20'
        ];
    }
}
