<?php

namespace App\Jobs;

use App\Models\User;
use App\Traits\PushNotification;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendPushViaFirebaseJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(protected array $notification)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $users = User::with('devices')->get();
        PushNotification::sendNotificationsToUsers($users, $this->notification);
    }
}
