<?php

namespace App\Models\Buyer;

use App\Models\Model;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Buyer extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function user()
    {
        return $this->morphOne(User::class, 'model')->withTrashed();
    }

    public function sendOtpVerificationEmail()
    {
        $this->notify(new SendOtpEmailNotification());
    }
}
