<?php

namespace App\Models\Dealers;

use App\Enum\Status;
use App\Models\User;
use App\Models\Media;
use App\Models\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Dealer extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function user()
    {
        return $this->morphOne(User::class, 'model')->withTrashed();
    }

    public function representatives()
    {
        return $this->hasMany(DealerRepresentatives::class);
    }

    public function finances()
    {
        return $this->hasMany(DealerFinance::class);
    }

    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }

    public function addresses()
    {
        return $this->morphMany(Address::class, 'addressable');
    }

    public function branches()
    {
        return $this->hasMany(DealerBranches::class);
    }

    public function operations()
    {
        return $this->hasMany(DealerOperation::class);
    }
}
