<?php

namespace App\Models;

use App\Models\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class DexUser extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [

        'uuid',
        'first_name',
        'last_name',
        'email',
        'updated_at',
    ];


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($query) {
            $query->updated_at = null;
        });
    }
}
