<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Model;
class Documentation extends Model
{
    use HasFactory, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'uuid',

        'key',
        'title',
        'slug',
        'content',

        'is_deletable',

        'updated_at',
    ];

    /**
     * Scope a query to only include deletable models.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeDeletable($query)
    {
        return $query->whereIsDeletable(true);
    }

    /**
     * Scope a query to only include non-deletable models.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */

    public function scopeNotDeletable($query)
    {
        return $query->whereIsDeletable(false);
    }
}
