<?php

namespace App\Models;
class GeneralNotifications extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'uuid',

        'title',
        'message',

        'updated_at',
    ];

    public function createdAt($isHumanTime = true): string
    {
        return $isHumanTime
            ? humanTime($this->created_at)
            : frontendDateTime($this->created_at);
    }

    public function updatedAt($isHumanTime = true): string
    {
        if (empty($this->updated_at)) return '<small><i>Never Updated</i></small>';

        return $isHumanTime
            ? humanTime($this->updated_at)
            : frontendDateTime($this->updated_at);
    }
}
