<?php

namespace App\Models;
use App\Enum\ListingStatus;
use App\Traits\HasListingStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Listing extends Model
{
    use HasFactory, SoftDeletes, HasListingStatus;

    protected $keyType = 'string';
    public $incrementing = false;

    protected $fillable = [
        'id',
        'uuid',
        'title',
        'description',
        'price',
        'financing_options',
        'location',
        'image_url',
        'owner_id',
        'status',
        'condition_id',
    ];

    protected $casts = [
        'image_url' => 'array',
        'financing_options' => 'array',
        'price' => 'decimal:2',
        'status' => \App\Enum\ListingStatus::class,
    ];

    protected $guarded = [];

    /**
     * Get the owner (dealer) of the listing.
     */
    public function owner()
    {
        return $this->belongsTo(\App\Models\User::class, 'owner_id');
    }

    /**
     * Get the vehicle specification for the listing.
     */
    public function specification()
    {
        return $this->hasOne(VehicleSpecification::class, 'listing_id', 'id');
    }

    /**
     * Get the features for the listing.
     */
    public function features()
    {
        return $this->belongsToMany(VehicleFeature::class, 'listing_features', 'listing_id', 'feature_id');
    }

    /**
     * Get the condition for the listing.
     */
    public function condition()
    {
        return $this->belongsTo(Condition::class);
    }
}
