<?php

namespace App\Models;

use App\Enum\Status;
use App\Traits\HasStatus;
use Illuminate\Database\Eloquent\Model as Eloquent;

class Model extends Eloquent
{
    use HasStatus;
    /**
     * The "booting" method of the model.
     *
     * @return void
     */
    protected static function boot()
    {
        parent::boot();

        // auto-sets values on creation
        static::creating(function ($query) {
            $query->uuid = !empty($query->uuid) ? $query->uuid : getUuid();
            $query->updated_at = null;
        });
    }

    protected $casts = [
        'status' => Status::class,
    ];
}
