<?php

namespace App\Models;

use App\Models\Model;
class Page extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'uuid',

        'name',
        'slug',
        'description',

        'is_deletable',

        'updated_at',
    ];

    /**
     * Returns true if the page is deletable, false otherwise.
     *
     * @return bool
     */
    public function isDeletable(): bool
    {
        return $this->is_deletable;
    }

    /**
     * Get the creation date of the page.
     *
     * @param bool $isHumanTime Whether to return a human-readable time format.
     * @return string The creation date in the specified format.
     */
    public function createdAt($isHumanTime = true): string
    {
        return $isHumanTime
            ? humanTime($this->created_at)
            : frontendDateTime($this->created_at);
    }

    public function updatedAt($isHumanTime = true): string
    {
        if (empty($this->updated_at)) return '<small><i>Never Updated</i></small>';

        return $isHumanTime && !empty($this->updated_at)
            ? humanTime($this->updated_at)
            : frontendDateTime($this->updated_at);
    }
}
