<?php

namespace App\Models;

use Spatie\Permission\Models\Role as ModelsRole;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Role extends ModelsRole
{
    use HasFactory;

    public const SUPER_ADMIN = 'super_admin';
    public const ADMIN = 'admin';
    public const DEALER = 'dealer';
    public const BUYER = 'buyer';
    public const USER = 'user';

    protected static function boot()
    {
        parent::boot();

        // auto-sets values on creation
        static::creating(function ($query) {
            $query->uuid = !empty($query->uuid) ? $query->uuid : getUuid();
        });
    }

    /**
     * Get the creation date of the adventure exercise.
     *
     * @param bool $isHumanTime Whether to return a human-readable time format.
     * @return string The creation date in the specified format.
     */
    public function createdAt($isHumanTime = true): string
    {
        return $isHumanTime
            ? humanTime($this->created_at)
            : frontendDateTime($this->created_at);
    }

    /**
     * Get the last update date of the adventure exercise.
     *
     * @param bool $isHumanTime Whether to return a human-readable time format.
     * @return string The last update date in the specified format.
     */
    public function updatedAt($isHumanTime = true): string
    {
        if (empty($this->updated_at)) return '<small><i>Never Updated</i></small>';

        return $isHumanTime
            ? humanTime($this->updated_at)
            : frontendDateTime($this->updated_at);
    }
}
