<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleFeature extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'category',
    ];

    /**
     * Get the listings that have this feature.
     */
    public function listings()
    {
        return $this->belongsToMany(Listing::class, 'listing_features', 'feature_id', 'listing_id');
    }
}
