<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VehicleSpecification extends Model
{
    use HasFactory;

    protected $fillable = [
        'listing_id',
        // Basic Information
        'make',
        'model',
        'year',
        'trim',
        'vin',
        // Technical Specifications
        'engine_capacity',
        'fuel_type',
        'transmission',
        'drive_type',
        'mileage',
        // Body & Exterior
        'body_type',
        'exterior_color',
        'interior_color',
        'seats',
        'doors',
    ];

    protected $casts = [
        'year' => 'integer',
        'engine_capacity' => 'integer',
        'mileage' => 'integer',
        'seats' => 'integer',
        'doors' => 'integer',
    ];

    /**
     * Get the listing that owns the specification.
     */
    public function listing()
    {
        return $this->belongsTo(Listing::class, 'listing_id', 'id');
    }
}
