<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use App\Traits\PushNotification;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class PushNotificationManager extends Notification implements ShouldQueue
{
    use Queueable;

    private $notification;
    private $users;

    /**
     * Create a new notification instance.
     */
    public function __construct($notification, $users)
    {
        $this->notification = $notification;
        $this->users = $users;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('/'))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $notification =  [
            'title'         => $this->notification['title'],
            'body'          => $this->notification['body'],
            'payload'       => isset($this->notification['payload']) && !empty($this->notification['payload']) ? $this->notification['payload'] : ['redirect_url' => ''],
        ];

        PushNotification::sendNotificationsToUsers($this->users, $notification);
        return $notification;
    }
}
