<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ResetPasswordNotification extends Notification implements ShouldQueue
{
    use Queueable;

    private $token;

    /**
     * Create a new notification instance.
     */
    public function __construct(public $data, public $locale = 'it')
    {
        $this->token = $data;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->view('emails.notification', [
                'subject' => trans('mail.page.reset_password.subject'),
                'name' => $notifiable?->name,
                'content' => trans('mail.page.reset_password.content'),
                'meta' => [
                    'heading' => trans('mail.page.reset_password.heading') . ' ' . config('app.name'),
                    'note' => trans('mail.page.reset_password.note'),
                    'url' => route('password.reset', [
                        'token' => $this->token,
                        'email' => $notifiable->getEmailForPasswordReset(),
                    ]),
                    'button_text' => trans('mail.page.buttons.reset_password'),
                ]
            ])
            ->subject(trans('mail.page.reset_password.subject'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
