<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Password;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class SendEmailVerificationNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(private string $role, public $locale = 'it')
    {
        $this->locale = $locale;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        app()->setLocale($this->locale);

        return (new MailMessage)
            ->view('emails.notification', [
                'subject' => trans('mail.page.verification.subject') . ' ' . config('app.name'),
                'name' => $notifiable?->full_name,
                'content' => trans('mail.page.verification.content'),
                'meta' => [
                    'heading' => trans('mail.page.verification.heading') . ' ' . config('app.name'),
                    'note' => trans('mail.page.verification.note'),
                    'url' => route('password.reset', [
                        'token' => Password::createToken($notifiable),
                        'email' => $notifiable->email,
                    ]),
                    'button_text' => trans('mail.page.buttons.verification'),
                ]
            ])
            ->subject(trans('mail.page.verification.subject') . ' ' . config('app.name'));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
