<?php

namespace App\Providers;

use App\Enum\Status;
use App\Models\Term;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\ServiceProvider;

class LayoutServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        view()->composer(['layouts.app', 'layouts.dealer.app'], function ($view) {
            $view->with([
                'isDarkMode' => !empty(auth()->user()->settings()->where([
                    'key' => 'is_dark_mode',
                    'value' => true,
                ])->first()),
                'isCompactSidebar' => !empty(auth()->user()->settings()->where([
                    'key' => 'is_compact_sidebar',
                    'value' => true,
                ])->first()),
            ]);
        });

        view()->composer('layouts.sidebar', function ($view) {
            $user = auth()->user();

            if ($user && $user->hasRole(Role::USER)) {
                $layout = 'layouts.navigation-buyers';
            } else {
                $layout = in_array($user?->status, [
                    Status::PENDING,
                    Status::INVITED,
                    Status::VERIFIED,
                ])
                    ? 'layouts.navigation-verified'
                    : 'layouts.navigation';
            }
            
            // Don't override navigation for dealers - they use separate layout
            if (!$user->hasRole(Role::DEALER)) {
                $view->with('navigationLayout', $layout);
            }
        });

        view()->composer('layouts.dealer.sidebar', function ($view) {
            $user = auth()->user();
            $view->with('navigationLayout', 'layouts.dealer.navigation-verified');
        });

        view()->composer('layouts.footer', function ($view) {
            $view->with([
                'terms' => Term::where('position', 'like', 'guest_footer%')->whereNotNull('slug')->get(),
            ]);
        });
    }
}
