<?php

namespace App\Providers;

use App\Models\Buyer\Buyer;
use App\Models\Condition;
use App\Models\Dealers\Dealer;
use App\Models\Listing;
use App\Models\User;
use App\Repositories\Contracts\BuyerRepositoryInterface;
use App\Repositories\Contracts\ConditionRepositoryInterface;
use App\Repositories\Contracts\DealerRepositoryInterface;
use App\Repositories\Contracts\ListingRepositoryInterface;
use App\Repositories\Contracts\UserRepositoryInterface;
use App\Repositories\Eloquent\BuyerRepository;
use App\Repositories\Eloquent\ConditionRepository;
use App\Repositories\Eloquent\DealerRepository;
use App\Repositories\Eloquent\ListingRepository;
use App\Repositories\Eloquent\UserRepository;
use Illuminate\Support\ServiceProvider;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register(): void
    {
        // Bind Listing Repository
        $this->app->bind(
            ListingRepositoryInterface::class,
            function ($app) {
                return new ListingRepository(new Listing());
            }
        );

        // Bind Condition Repository
        $this->app->bind(
            ConditionRepositoryInterface::class,
            function ($app) {
                return new ConditionRepository(new Condition());
            }
        );

        // Bind Dealer Repository
        $this->app->bind(
            DealerRepositoryInterface::class,
            function ($app) {
                return new DealerRepository(new Dealer());
            }
        );

        // Bind User Repository
        $this->app->bind(
            UserRepositoryInterface::class,
            function ($app) {
                return new UserRepository(new User());
            }
        );

        // Bind Buyer Repository
        $this->app->bind(
            BuyerRepositoryInterface::class,
            function ($app) {
                return new BuyerRepository(new Buyer());
            }
        );
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot(): void
    {
        //
    }
}

