<?php

namespace App\Repositories\Contracts;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

interface BuyerRepositoryInterface extends RepositoryInterface
{
    /**
     * Get buyer by user ID.
     *
     * @param int $userId
     * @param array $with
     * @return Model|null
     */
    public function findByUserId(int $userId, array $with = ['user']): ?Model;

    /**
     * Get buyer by user email.
     *
     * @param string $email
     * @param array $with
     * @return Model|null
     */
    public function findByUserEmail(string $email, array $with = ['user']): ?Model;
}

