<?php

namespace App\Repositories\Contracts;

use Illuminate\Database\Eloquent\Collection;

interface ConditionRepositoryInterface extends RepositoryInterface
{
    /**
     * Get all active conditions.
     *
     * @return Collection
     */
    public function getActive(): Collection;

    /**
     * Get conditions with listing counts.
     *
     * @return Collection
     */
    public function getWithCounts(): Collection;
}

