<?php

namespace App\Repositories\Contracts;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

interface DealerRepositoryInterface extends RepositoryInterface
{
    /**
     * Get dealer by user ID.
     *
     * @param int $userId
     * @param array $with
     * @return Model|null
     */
    public function findByUserId(int $userId, array $with = ['user']): ?Model;

    /**
     * Get verified dealers.
     *
     * @param array $with
     * @return Collection
     */
    public function getVerified(array $with = ['user']): Collection;

    /**
     * Get dealer with full details.
     *
     * @param string $uuid
     * @param array $with
     * @return Model|null
     */
    public function findByUuidWith(
        string $uuid,
        array $with = ['user', 'representatives', 'finances', 'branches', 'operations']
    ): ?Model;
}

