<?php

namespace App\Repositories\Eloquent;

use App\Models\Buyer\Buyer;
use App\Repositories\Contracts\BuyerRepositoryInterface;
use Illuminate\Database\Eloquent\Model;

class BuyerRepository extends BaseRepository implements BuyerRepositoryInterface
{
    /**
     * Get buyer by user ID.
     *
     * @param int $userId
     * @param array $with
     * @return Model|null
     */
    public function findByUserId(int $userId, array $with = ['user']): ?Model
    {
        return $this->model
            ->with($with)
            ->whereHas('user', function ($query) use ($userId) {
                $query->where('id', $userId);
            })
            ->first();
    }

    /**
     * Get buyer by user email.
     *
     * @param string $email
     * @param array $with
     * @return Model|null
     */
    public function findByUserEmail(string $email, array $with = ['user']): ?Model
    {
        return $this->model
            ->with($with)
            ->whereHas('user', function ($query) use ($email) {
                $query->where('email', $email);
            })
            ->first();
    }
}

