<?php

namespace App\Repositories\Eloquent;

use App\Models\Condition;
use App\Repositories\Contracts\ConditionRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class ConditionRepository extends BaseRepository implements ConditionRepositoryInterface
{

    /**
     * Get all active conditions.
     *
     * @return Collection
     */
    public function getActive(): Collection
    {
        return $this->model
            ->where('is_active', true)
            ->orderBy('sort_order')
            ->get();
    }

    /**
     * Get conditions with listing counts.
     *
     * @return Collection
     */
    public function getWithCounts(): Collection
    {
        return $this->model
            ->withCount('listings')
            ->where('is_active', true)
            ->orderBy('sort_order')
            ->get();
    }
}

