<?php

namespace App\Services\ActivityLogs;

use App\Models\User;
use App\Models\ActivityLog;
use App\Library\HttpRequest;
use Illuminate\Support\Facades\Log;

class ActivityLogBaseService
{
    /**
     * Initialize the service
     *
     * @param string $module
     * @param \App\Models\User $user
     */
    public function __construct(
        protected string $module,
        protected User $user
    ) {}

    /**
     * Actually try to log an activity
     *
     * @param string $activity
     * @param string $description
     * @return void
     */
    protected function log(
        string $activity,
        string $description
    ) {
        try {
            ActivityLog::create([
                'user_id' => $this->user->id,
                'module' => $this->module,
                'activity' => $activity,
                'description' => $description,
                'meta' => json_encode([
                    'ip' => HttpRequest::getIp(),
                    'client' => HttpRequest::getClient(),
                ]),
            ]);
        } catch (\Exception $e) {
            Log::channel('activitylog')->error("Error creating {$this->module} {$activity} for user_id {$this->user->id}." . $e->getMessage());
        }
    }
}
