<?php

namespace App\Services\ActivityLogs;

use App\Models\Documentation;
use App\Models\User;
use App\Services\ActivityLogs\ActivityLogBaseService;

class DocumentationLogService extends ActivityLogBaseService
{
    /**
     * Initialize the service
     *
     * @param \App\Models\User|null $user
     */
    public function __construct(
        User|null $user = null,
    ) {
        parent::__construct('documentation', $user ?? auth()->user());
    }

    /**
     * Log activity when documentation is created
     *
     * @return void
     */
    public function created()
    {
        $this->log(
            activity: 'created',
            description: "{$this->user->email} has created a custom documentation."
        );
    }

    /**
     * Log activity when documentation is updated
     *
     * @param \App\Models\Documentation $documentation
     * @return void
     */
    public function updated(Documentation $documentation)
    {
        $this->log(
            activity: 'updated',
            description: "{$this->user->email} has updated the \"{$documentation->key}\" documentation."
        );
    }

    /**
     * Log activity when documentation is deleted
     *
     * @param \App\Models\Documentation $documentation
     * @return void
     */
    public function deleted(Documentation $documentation)
    {
        $this->log(
            activity: 'deleted',
            description: "{$this->user->email} has deleted the \"{$documentation->key}\" documentation."
        );
    }

    /**
     * Log activity when documentation has restored
     *
     * @param \App\Models\Documentation $documentation
     * @return void
     */
    public function restored(Documentation $documentation)
    {
        $this->log(
            activity: 'restored',
            description: "{$this->user->email} has restored the \"{$documentation->key}\" documentation."
        );
    }
}
