<?php

namespace App\Services\ActivityLogs;

use App\Models\Role;
use App\Models\User;
use App\Services\ActivityLogs\ActivityLogBaseService;

class RoleLogService extends ActivityLogBaseService
{
    /**
     * Initialize the service
     *
     * @param \App\Models\User|null $user
     */
    public function __construct(
        User|null $user = null,
    ) {
        parent::__construct('role', $user ?? auth()->user());
    }

    /**
     * Log activity when role is created
     *
     * @param \App\Models\Role $role
     * @return void
     */
    public function created(Role $role)
    {
        $this->log(
            activity: 'created',
            description: "{$this->user->email} created role {$role->name}."
        );
    }

    /**
     * Log activity when role is updated
     *
     * @param \App\Models\Role $role
     * @return void
     */
    public function updated(Role $role)
    {
        $this->log(
            activity: 'updated',
            description: "{$this->user->email} updated role {$role->name}."
        );
    }

    /**
     * Log activity when role is deleted
     *
     * @param \App\Models\Role $role
     * @return void
     */
    public function deleted(Role $role)
    {
        $this->log(
            activity: 'deleted',
            description: "{$this->user->email} deleted role {$role->name}."
        );
    }

    /**
     * Log activity when role is restored
     *
     * @param \App\Models\Role $role
     * @return void
     */
    public function restored(Role $role)
    {
        $this->log(
            activity: 'restored',
            description: "{$this->user->email} restored role {$role->name}."
        );
    }
}
