<?php

namespace App\Services\ActivityLogs;

use App\Models\Term;
use App\Models\User;
use App\Services\ActivityLogs\ActivityLogBaseService;

class TermsAndConditionsLogService extends ActivityLogBaseService
{
    /**
     * Initialize the service
     *
     * @param \App\Models\User|null $user
     */
    public function __construct(
        User|null $user = null
    ) {
        parent::__construct('terms_and_conditions', $user ?? auth()->user());
    }

    /**
     * Log activity when any of the Terms & Condition has been accepted
     *
     * @param string $for
     * @return void
     */
    public function accepted(string $for)
    {
        $this->log(
            activity: 'accepted',
            description: "{$this->user->email} has accepted terms & conditions for {$for}."
        );
    }

    /**
     * Log activity when existing terms & conditions has been updated
     *
     * @param \App\Models\Term $term
     * @return void
     */
    public function updated(Term $term)
    {
        $position = ucwords(str_replace('_', ' ', $term->position));

        $this->log(
            activity: 'updated',
            description: "{$this->user->email} has updated the terms & conditions for position: {$position}."
        );
    }
}
