<?php

namespace App\Services\ActivityLogs;

use App\Models\User;
use App\Services\ActivityLogs\ActivityLogBaseService;

class UserLogService extends ActivityLogBaseService
{
    /**
     * Initialize the service
     *
     * @param \App\Models\User|null $user
     */
    public function __construct(
        User|null $user = null,
    ) {
        parent::__construct('user', $user ?? auth()->user());
    }

    /**
     * Log user invitation activity
     *
     * @param \App\Models\User $invitedUser
     * @return void
     */
    public function invited(User $invitedUser)
    {
        $this->log(
            activity: 'invited',
            description: "{$this->user->email} has invited {$invitedUser->email}.",
        );
    }

    /**
     * Log user re-invitation activity
     *
     * @param \App\Models\User $invitedUser
     * @return void
     */
    public function reinvited(User $invitedUser)
    {
        $this->log(
            activity: 'reinvited',
            description: "{$this->user->email} has reinvited {$invitedUser->email}.",
        );
    }

    /**
     * Log user activation activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function activated(User $subjectUser)
    {
        $this->log(
            activity: 'activated',
            description: "{$this->user->email} has activated {$subjectUser->email}.",
        );
    }

    /**
     * Log user suspension activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function suspended(User $subjectUser)
    {
        $this->log(
            activity: 'suspended',
            description: "{$this->user->email} has suspended {$subjectUser->email}.",
        );
    }

    /**
     * Log user deletion activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function deleted(User $subjectUser)
    {
        $this->log(
            activity: 'deleted',
            description: "{$this->user->email} has deleted {$subjectUser->email}.",
        );
    }

    /**
     * Log user approve activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function approved(User $subjectUser)
    {
        $this->log(
            activity: 'approved',
            description: "{$this->user->email} has approved {$subjectUser->email}.",
        );
    }

    /**
     * Log user restoration activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function restored(User $subjectUser)
    {
        $this->log(
            activity: 'restored',
            description: "{$this->user->email} has been restored {$subjectUser->email}.",
        );
    }

    /**
     * Log user rejection activity
     *
     * @param \App\Models\User $subjectUser
     * @return void
     */
    public function rejected(User $subjectUser)
    {
        $this->log(
            activity: 'rejected',
            description: "{$this->user->email} has rejected {$subjectUser->email}.",
        );
    }
}
