<?php

namespace App\Services;

use App\Models\User;

class AuthorizeRouteService
{
    public static function getIntendedRoute(User|null $user): string
    {
        if (empty($user)) return 'login';

        $intendedRoute = 'profile.index';

        $routesList = [
            'dealers.dashboard.view' => 'dealers.dashboard',
            'dashboard.view' => 'dashboard',
            'customer.view' => 'customers.index',
            'service_provider.view' => 'service_providers.index',
            'role.view' => 'roles.index',
            'page.view' => 'pages.index',
            'notification.view' => 'notifications.index',
        ];

        foreach ($routesList as $permission => $routeName) {
            if ($user?->can($permission)) {
                $intendedRoute = $routeName;

                break;
            }
        }

        return $intendedRoute;
    }
}
