<?php

namespace App\Traits;


use App\Enum\ListingStatus;

trait HasListingStatus
{

    public function getStatusBadge(): string
    {
        return $this->status?->badge() ?? '<span class="badge">Unknown</span>';
    }

    // You can add other shared methods or scopes
    public function scopeActive($query)
    {
        return $query->where('status', ListingStatus::ACTIVE);
    }
}
