<?php

namespace Database\Factories\Dealers;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class DealerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'company_name' => $this->faker->company . ' Motors',
            'registration_number' => 'REG-' . $this->faker->unique()->numerify('#######'),
            'tax_identification_number' => 'TIN-' . $this->faker->unique()->numerify('#########'),
            'verified_at' => $this->faker->optional()->dateTimeThisYear(),
        ];
    }
}
