<?php

namespace Database\Factories;

use App\Enum\ListingStatus;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Listing>
 */
class ListingFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $carBrands = ['Honda', 'Toyota', 'BMW', 'Mercedes', 'Audi', 'Ford', 'Chevrolet', 'Nissan', 'Hyundai', 'Kia'];
        $locations = [
            'New York',
            'Los Angeles',
            'Chicago',
            'Houston',
            'Miami',
            'San Francisco',
            'Seattle',
            'Boston',
        ];

        $make = fake()->randomElement($carBrands);
        $model = fake()->word();
        $year = fake()->year();

        return [
            'id' => Str::random(20),
            'uuid' => Str::uuid(),
            'title' => $year . ' ' . $make . ' ' . $model,
            'description' => fake()->paragraph(3),
            'price' => fake()->randomFloat(2, 10000, 100000),
            'financing_options' => fake()->randomElements(['loan', 'lease', 'cash'], rand(1, 3)),
            'location' => fake()->randomElement($locations),
            'image_url' => [
                'https://static.toiimg.com/photo/80387978.cms',
                'https://img.etimg.com/thumb/width-1200,height-900,imgsize-69266,resizemode-75,msid-106774994/industry/auto/cars-uvs/super-sports-car-segment-in-india-to-register-30-pc-growth-this-year-mclaren-automotive.jpg',
            ],
            'owner_id' => User::role('dealer')->inRandomOrder()->first()?->id ?? User::factory()->create()->id,
            'status' => fake()->randomElement([ListingStatus::PENDING, ListingStatus::ACTIVE, ListingStatus::APPROVED]),
            'status' => fake()->randomElement([ListingStatus::PENDING, ListingStatus::APPROVED]),
        ];
    }
}
