<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\VehicleSpecification>
 */
class VehicleSpecificationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $makes = ['Honda', 'Toyota', 'BMW', 'Mercedes', 'Audi', 'Ford', 'Chevrolet', 'Nissan', 'Hyundai', 'Kia'];
        $bodyTypes = ['SUV', 'sedan', 'pickup', 'coupe', 'hatchback', 'van', 'convertible'];
        $fuelTypes = ['gasoline', 'diesel', 'hybrid', 'electric'];
        $transmissions = ['automatic', 'manual'];
        $driveTypes = ['AWD', 'FWD', 'RWD', '4WD'];
        $colors = ['Black', 'White', 'Silver', 'Gray', 'Red', 'Blue', 'Green', 'Brown', 'Beige'];

        return [
            // Basic Information
            'make' => fake()->randomElement($makes),
            'model' => ucfirst(fake()->word()),
            'year' => fake()->numberBetween(2010, 2024),
            'trim' => fake()->optional()->randomElement(['Base', 'Sport', 'Limited', 'Premium', 'Luxury']),
            'vin' => strtoupper(fake()->bothify('??###??#########')), // 17 character VIN

            // Technical Specifications
            'engine_capacity' => fake()->randomElement([1500, 1800, 2000, 2500, 3000, 3500, 4000, 5000]),
            'fuel_type' => fake()->randomElement($fuelTypes),
            'transmission' => fake()->randomElement($transmissions),
            'drive_type' => fake()->randomElement($driveTypes),
            'mileage' => fake()->numberBetween(0, 200000),

            // Body & Exterior
            'body_type' => fake()->randomElement($bodyTypes),
            'exterior_color' => fake()->randomElement($colors),
            'interior_color' => fake()->randomElement($colors),
            'seats' => fake()->randomElement([2, 4, 5, 7, 8]),
            'doors' => fake()->randomElement([2, 4, 5]),
        ];
    }
}
