<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('dealer_branches', function (Blueprint $table) {
            $table->string('address')->nullable()->after('branch_name');
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::table('dealer_branches', function (Blueprint $table) {
            $table->dropColumn('address');
            $table->dropColumn('deleted_at');
        });
    }
};

