<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dx_services', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 16)->unique();

            $table->string('service_name');
            $table->tinyInteger('status')->default(\App\Enum\Status::ACTIVE);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dx_services');
    }
};
