<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dex_users', function (Blueprint $table) {
            $table->id();
            $table->string('uuid', 16)->unique();

            $table->string('first_name');
            $table->string('last_name');
            
            $table->string('email')->unique();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dex_users');
    }
};
